/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.appserver;

import filenet.pe.sso.CookieManager;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.soap.transport.VWSOAPHTTPConnection;
import filenet.vw.soap.util.VWSOAPUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Vector;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.Response;
import org.apache.soap.transport.SOAPTransport;

public class VWSIMSOAPUtils {
    private static Logger logger = Logger.getLogger("filenet.sim.appserver");
    private static final String m_className = "VWSIMSOAPUtils";
    private static HashMap m_HttpConnections = new HashMap();

    private static VWSOAPHTTPConnection getVWSOAPHttpConnection(String serverURL, String creds, String sessionId) {
        String key = serverURL + "_" + creds + "_" + sessionId;
        VWSOAPHTTPConnection c = (VWSOAPHTTPConnection)((Object)m_HttpConnections.get(key));
        if (c == null) {
            c = new VWSOAPHTTPConnection(creds, sessionId);
            m_HttpConnections.put(key, c);
            if (logger.isFinest()) {
                logger.finest(m_className, "getVWSOAPHttpConnection", "creating a new one.");
            }
        } else if (logger.isFinest()) {
            logger.finest(m_className, "getVWSOAPHttpConnection", "reuse");
        }
        return c;
    }

    public static Object invoke(String serverURL, String methodName, String[] paramNames, Object[] paramValues, Class[] paramClasses, String creds, String sessionId) throws VWException {
        Response resp;
        String m_method;
        block16: {
            Parameter sRet;
            Object msg;
            block17: {
                m_method = "invoke:" + methodName + ", serverURL=" + serverURL + ", sessionId=" + sessionId;
                logger.entering(m_className, m_method);
                SOAPMappingRegistry smr = new SOAPMappingRegistry();
                Call call = new Call();
                call.setSOAPMappingRegistry(smr);
                call.setTargetObjectURI("urn:filenet-sim-appserver");
                call.setEncodingStyleURI("http://schemas.xmlsoap.org/soap/encoding/");
                VWSOAPHTTPConnection conn = VWSIMSOAPUtils.getVWSOAPHttpConnection(serverURL, creds, sessionId);
                call.setSOAPTransport((SOAPTransport)conn);
                resp = null;
                call.setMethodName(methodName);
                if (paramNames != null) {
                    int paramCount = paramNames.length;
                    Vector<Parameter> params = new Vector<Parameter>(paramCount);
                    for (int i = 0; i < paramCount; ++i) {
                        params.addElement(new Parameter(paramNames[i], paramClasses[i], paramValues[i], null));
                    }
                    call.setParams(params);
                } else {
                    call.setParams(null);
                }
                URL sURL = new URL(serverURL);
                boolean tryAgain = false;
                while (true) {
                    try {
                        resp = call.invoke(sURL, "");
                    }
                    catch (SOAPException ex) {
                        msg = ex.getMessage();
                        if (((String)msg).indexOf("AUTOSUBMIT") == -1) {
                            throw new VWException(ex);
                        }
                        Thread.sleep(100L);
                        sessionId = CookieManager.checkSMCookies(sessionId, sURL, null);
                        conn.setSessionId(sessionId);
                        logger.info(m_className, m_method, "GOT NEW COOKIE, RETRYING CALL, Got: " + (String)msg);
                        tryAgain = true;
                        if (tryAgain) continue;
                    }
                    break;
                }
                if (resp.generatedFault()) break block16;
                sRet = resp.getReturnValue();
                if (sRet != null) break block17;
                msg = null;
                Object var19_23 = null;
                logger.exiting(m_className, m_method);
                return msg;
            }
            msg = sRet.getValue();
            Object var19_24 = null;
            logger.exiting(m_className, m_method);
            return msg;
        }
        try {
            try {
                Fault fault = resp.getFault();
                logger.severe(m_className, m_method, "FAULT=" + fault.toString());
                String faultString = fault.getFaultString();
                Object obj = VWSOAPUtils.base64ObjectDeserializer(faultString);
                if (obj != null && obj instanceof Exception) {
                    logger.info(m_className, m_method, "Got Exception:" + obj.getClass().getName() + ",msg=" + obj.toString());
                    throw (Exception)obj;
                }
                if (faultString != null) {
                    logger.info(m_className, m_method, "Normal Exception..");
                    String newFaultString = VWSIMSOAPUtils.filterAmpCode(faultString);
                    faultString = VWSIMSOAPUtils.filterAmpCode(newFaultString);
                }
                throw new Exception(faultString);
            }
            catch (VWException vwe) {
                throw vwe;
            }
            catch (Throwable t) {
                throw new VWException(t);
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    private static String filterAmpCode(String strIn) {
        String strOut = "";
        for (int i = 0; i < strIn.length(); ++i) {
            if (strIn.charAt(i) == '&') {
                int temp = strIn.indexOf(59, i) + 1;
                if (temp == -1) continue;
                String strCode = strIn.substring(i, temp);
                if (strCode.compareToIgnoreCase("&amp;") == 0) {
                    strOut = strOut + "&";
                }
                if (strCode.compareToIgnoreCase("&lt;") == 0) {
                    strOut = strOut + "<";
                }
                if (strCode.compareToIgnoreCase("&gt;") == 0) {
                    strOut = strOut + ">";
                }
                if (strCode.compareToIgnoreCase("&quot;") == 0) {
                    strOut = strOut + "\"";
                }
                if (strCode.compareToIgnoreCase("&apos;") == 0) {
                    strOut = strOut + "'";
                }
                i = temp - 1;
                continue;
            }
            strOut = strOut + strIn.charAt(i);
        }
        return strOut;
    }
}

